﻿WITH   RECURSIVE journal (heure_audit,marche) AS (
VALUES (CAST('2010-01-01 23:10:00.000' AS TIMESTAMP),TRUE),
       (CAST('2010-01-01 23:20:00.000' AS TIMESTAMP),TRUE),
       (CAST('2010-01-01 23:30:00.000' AS TIMESTAMP),FALSE),
       (CAST('2010-01-01 23:40:00.000' AS TIMESTAMP),TRUE),
       (CAST('2010-01-01 23:50:00.000' AS TIMESTAMP),FALSE),
       (CAST('2010-01-02 00:00:00.000' AS TIMESTAMP),FALSE),
       (CAST('2010-01-02 00:10:00.000' AS TIMESTAMP),TRUE)),
       rupture_journal (rupture,ordre,heure_audit,marche) AS (
SELECT COALESCE((LAG(marche) OVER w_tri_heure)!=marche,TRUE) AS rupture,
       RANK() OVER w_tri_heure AS ordre,heure_audit,marche
FROM   journal
WINDOW w_tri_heure AS (ORDER BY heure_audit)),
       recursif_plage_rupture(rupture,ordre,plage,heure_audit,marche) AS (
SELECT rupture,ordre,1,heure_audit,marche FROM rupture_journal WHERE ordre=1
UNION  ALL
SELECT rupture_journal.rupture,rupture_journal.ordre,
       CASE rupture_journal.rupture WHEN TRUE THEN plage+1 ELSE plage END AS plage,
       rupture_journal.heure_audit,rupture_journal.marche
FROM   rupture_journal JOIN recursif_plage_rupture 
       ON rupture_journal.ordre=recursif_plage_rupture.ordre+1),
       plage_reelle (plage,marche,heure_min,heure_max) AS (     
SELECT plage,marche,MIN(heure_audit),MAX(heure_audit) FROM recursif_plage_rupture
GROUP  BY plage,marche ORDER  BY plage)
SELECT COALESCE(date_trunc('second', 
       ((heure_min-LAG(heure_max) OVER w_tri_plage)/2)+LAG(heure_max) OVER w_tri_plage),
       CAST(SUBSTR(TO_CHAR(heure_min,'YYYY-MM-DD hh24:mm:ss'),1,14)||'00:00' AS TIMESTAMP)) AS "Début plage estimée",
       COALESCE(DATE_TRUNC('second',(lead(heure_min) OVER w_tri_plage -heure_max)/2+heure_max),
       CASE SUBSTR(TO_CHAR(heure_max,'YYYY-MM-DD hh24:mm:ss'),15,5)
            WHEN '00:00' THEN heure_max
            ELSE CAST(SUBSTR(TO_CHAR(heure_max,'YYYY-MM-DD hh24:mm:ss'),1,14)||'00:00' AS TIMESTAMP)
                 +interval '1 hour' END) AS "Fin plage estimée",
       CASE marche WHEN TRUE THEN 'MARCHE' ELSE 'ARRET' END AS "Statut serveur"
FROM   plage_reelle WINDOW w_tri_plage AS (ORDER BY plage);